<?php
/*
Plugin Name: FormPress
Plugin URI: http://almostdaniel.com/formpress
Description: This is a plugin that turns any WordPress installation into a web form database and processing agent.
Author: daniel spillers - byron herrera
Version: 0.4-pre
Author URI: http://almostdaniel.com/
*/


/*  Copyright 2009  byron herrera    (email : bh@axul.net)
    Copyright 2007  daniel spillers  (email : writeme@almostdaniel.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

define('FORMPRESS_VERSION', '0.4');
define('PLUGINDIR', 'wp-content/plugins');
define('FORMPRESSPLUGINDIR', ABSPATH.PLUGINDIR);
require_once(FORMPRESSPLUGINDIR.'/formpress/functions.php');
global $wp_db_version;

function formpress_add_pages() {
	/* add_management_page(page_title, menu_title, access_level/capability, file, [function]); */
 	// add_management_page(__('Forms'), __('Forms'), 5, 'formpress/manage.php');
 	add_menu_page(__('Forms'), __('Forms'), 5, 'formpress/manage.php');
}

function formpress_install($force = '') {
	global $wpdb;
	
	require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
	
	/* Create plugin tables if they do not already exist */
	
	$table_name = $wpdb->prefix . 'formpress_forms';
	if ( $wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name ) {
		$SQL = "CREATE TABLE `$table_name` (
 			`ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
			`name` TEXT NOT NULL,
			`description` TEXT,
			`owner` BIGINT(20) NOT NULL,
			`notify` TINYINT(1),
			`email` TEXT,
			`confirmURI` TEXT,
			`dateCreated` DATETIME NOT NULL,
			PRIMARY KEY (`ID`)
			)
			CHARACTER SET utf8;";
		dbDelta($SQL);
	}
	
	$table_name = $wpdb->prefix . 'formpress_fields';
	if ( $wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name ) {
		$SQL = "CREATE TABLE `$table_name` (
  			`ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
			`form` INT UNSIGNED NOT NULL,
			`name` TEXT NOT NULL,
			`description` TEXT,
			`size` INT UNSIGNED NOT NULL,
			`required` TINYINT(1) DEFAULT 0,
			`dateCreated` DATETIME NOT NULL,
			PRIMARY KEY (`ID`)
			)
			CHARACTER SET utf8;";
		dbDelta($SQL);
	}
 	$table_name = $wpdb->prefix . 'formpress_data';
	if ( $wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name ) {
		$SQL = "CREATE TABLE `$table_name` (
 			`session` INT UNSIGNED NOT NULL,
			`form` INT UNSIGNED NOT NULL,
			`field` INT UNSIGNED NOT NULL,
			`value` TEXT
			)
			CHARACTER SET utf8;";
		dbDelta($SQL);
	}

/*

To update database:

 CREATE TABLE `wp_formpress_select` (
`ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`form` int( 10 ) unsigned NOT NULL ,
`field` int( 10 ) unsigned NOT NULL ,
`value` varchar( 50 ) ,
`data` varchar( 255 )
) 
CREATE TABLE `wp_formpress_fields_by_form` (
`ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`form` INT NOT NULL ,
`field` INT NOT NULL
) ENGINE = MYISAM ;
ALTER TABLE `wp_formpress_fields` ADD `dependent` INT NOT NULL AFTER `required` ;
ALTER TABLE `wp_formpress_select` ADD `dependent` INT NOT NULL ;
ALTER TABLE `wp_formpress_data` ADD `ID` INT NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST ;
ALTER TABLE `wp_formpress_fields` ADD `selectable` TINYINT( 1 ) NULL DEFAULT '0' AFTER `size` ;	
ALTER TABLE `wp_formpress_fields`  DROP `form`;
ALTER TABLE `wp_formpress_fields` CHANGE  `name`  `name` VARCHAR( 200 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL
ALTER TABLE `wp_formpress_forms` ADD `response` TEXT NOT NULL AFTER `confirmURI` ;
ALTER TABLE  `wp_formpress_forms` CHANGE  `name`  `name` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
CHANGE  `email`  `email` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
CHANGE  `confirmURI`  `confirmURI` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
ALTER TABLE `wp_formpress_fields_by_form` ADD `order_field` TINYINT NOT NULL ;
ALTER TABLE `wp_formpress_forms` ADD `button` VARCHAR( 255 ) NOT NULL AFTER `response` ;
ALTER TABLE `wp_formpress_fields` ADD `same` INT NULL DEFAULT '0' AFTER `dependent` ;
ALTER TABLE `wp_formpress_fields` ADD `value` VARCHAR( 100 ) NOT NULL DEFAULT '' AFTER `size` ;
*/

	add_option('formpress_version', FORMPRESS_VERSION);
}

function formpress_check_install() {
	$version = get_option('formpress_version');
	if ( empty($version) ) formpress_install();
}

function formpress_submit() {
	global $wpdb, $missing_fields;
	// $form_ID = $wpdb->escape($_REQUEST['formpress_submit']);
	$form_ID = $wpdb->escape($_REQUEST['form_ID']);
	if ( !empty($form_ID) ) {
		$missing_fields = formpress_do_submit($form_ID, $_REQUEST);
		// exit;
	}
}

function formpress_export() {
	global $wpdb;
	$form_ID = $wpdb->escape($_REQUEST['formpress_export']);
	if ( !empty($form_ID) ) {
		$format = $wpdb->escape($_REQUEST['format']);
		if ( !empty($format) ) formpress_do_export($form_ID, $format); 
	}
}

function formpress_css() {
	$site_url = get_bloginfo('url');
	echo '<link rel="stylesheet" type="text/css" href="'.$site_url.'/wp-content/plugins/formpress/css/index.css" />';
}

if (isset($_GET['formpress_getData']))
{
	formpress_showData();
	exit();
}

if (isset($_GET['formpress_lookForm']))
{
	formpress_showFormData();
	exit();
}

/* Actions */
if ( $wp_db_version >= 4772 ) {
	register_activation_hook(__FILE__, 'formpress_install');
} else {
	add_action('activate_formpress/formpress.php', 'formpress_install');
}

add_action('init', 'formpress_submit', 1);
add_action('init', 'formpress_export', 1);
add_action('plugins_loaded', 'formpress_check_install');
add_action('admin_head', 'formpress_css');
add_action('admin_menu', 'formpress_add_pages');
add_filter('wp_head', 'formpress_wp_css_js');
add_filter('wp_footer', 'formpress_js');

function formpress_js() {
	$site_url = get_bloginfo('url');
	echo '<!-- SCW Calendar - Formpress forms -->'."\n";
	echo '<script type="text/JavaScript" src="'.$site_url.'/wp-content/plugins/formpress/js/scw/scw.js"></script>'."\n";
	echo '<script type="text/JavaScript" src="'.$site_url.'/wp-content/plugins/formpress/js/scw/scwLanguages.js"></script>'."\n";
}


function formpress_content($text) {
	if (preg_match('/\[formpress_form:(.*?)\]/', $text, $match)) {
		// [formpress_form:0]
		// list($total, $show, $cat) = split(":", $match[1]);
		$text = preg_replace('/\[formpress_form:(.*?)\]/', formpress_the_html($match[1]), $text);
	}
	return $text;
}

add_filter('the_content', 'formpress_content');

?>