<?php
require_once(FORMPRESSPLUGINDIR.'/formpress/functions.php');
$site_url = get_bloginfo('url');
$base_url = "/wp-admin/edit.php?page=formpress";
$manage_url = $base_url . "/manage.php";
$export_url = $base_url . "/export.php";
$plugin_url = "/wp-content/plugins/formpress/";

function formpress_show_manage_page() {
	global $wpdb;
	global $user_ID, $user_email, $site_url, $manage_url, $export_url, $plugin_url;
	get_currentuserinfo();

	echo "<script type='text/javascript' src='".$site_url.$plugin_url."js/formpress.js'></script>\n";

	switch ( $wpdb->escape($_REQUEST['status']) ) {
		case 'addfield':
			formpress_notice_addfield();
			break;
		case 'savefield':
			formpress_notice_savefield();
			break;
		case 'deleteform':
			formpress_notice_deleteform();
			break;
		case 'deletefield':
			formpress_notice_deletefield();
			break;
		case 'deletedata':
			formpress_notice_deletedata();
			break;
		case 'saveform':
			formpress_notice_saveform();
			break;
		case 'export':
			formpress_notice_export();
			break;
	}

	switch ( $_REQUEST['action'] ) {
		case 'addform':
			$form_name = $wpdb->escape($_REQUEST['name']);
			$form_description = $wpdb->escape($_REQUEST['description']);
			if ( !empty($form_name) || !empty($user_ID) ) {
				// store form in db and grab ID
				$form_ID = formpress_add_form($form_name, $form_description, $user_ID);
				add_action( 'admin_notices', 'formpress_notice_addform', 3 );
				do_action( 'admin_notices' );
			} else {
				// ERROR
			}
					
		case 'editform':
			if ( empty($form_ID) ) $form_ID = $wpdb->escape($_REQUEST['id']);
			
			?>
            <div class="wrap">
            	<h2>Edit Form</h2>
                <form name="editform" id="editform" action="<?php echo $site_url.$manage_url; ?>&action=saveform&id=<?php echo $form_ID; ?>" method="post">
				<p>Here you finish configuring your form's dataset and behavior. Add a form field for each piece of data you'd like to collect. You can also change form options or preview some example HTML used to build the form's web page.</p>
                <ul>
                    <li><a href="#options">Options</a></li>
                    <li><a href="#example">Example HTML</a></li>
                </ul>
                <h3>Data Fields (<a href="<?php echo $site_url.$manage_url."&action=showfield&id=".$form_ID; ?>">add new</a>)</h3>
                <!--
                <table class="widefat">
                <thead>
                <tr>
                	<th scope="col">Name</th>
                    <th scope="col">Description <span class="description">(Do not use double-quotes)</span></th>
                    <th scope="col">Size</th>
                    <th scope="col">Type?</th>
                    <th scope="col">Required?</th>
                    <th scope="col">&nbsp;</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
                <ul>
              </ul>
                -->
                <table class="widefat">
                <thead>
                <tr>
                	<th scope="col">Name</th>
                    <th scope="col">Description <span class="description">(Do not use double-quotes)</span></th>
                	<th scope="col">Order</th>
                	<th scope="col">Edit</th>
                </tr>
                </thead>
                <tbody>
                <?php formpress_field_list($form_ID, 'table'); ?>
                </tbody>
                </table>
                
				
                <p class="submit"><input name="update" type="submit" value="Update" /></p>

                <h3 id="options">Options</h3>
                <table class="optiontable">
                <tr>
                <th scope="row">Form Name:</th>
                <td><input name="name" id="name" size="40" value="<?php formpress_form_name($form_ID); ?>" /></td>
                </tr>
                <tr>
                <th scope="row">Description (optional):</th>
                <td><textarea name="description" id="description" cols="60" rows="10"><?php formpress_form_description($form_ID); ?></textarea></td>
                </tr>
                <tr>
                <th scope="row">Confirmation URL (optional):<span class="description">Display this page after a form is submitted.</span></th>
                <td><input name="confirmURI" id="confirmURI" size="40" value="<?php formpress_form_confirmURI($form_ID); ?>"  /></td>
                </tr>
                <tr>
                <th scope="row">Email Notification (optional):<span class="description">Send email notification each time a form is submitted. Separate multiple
                email addresses with a comma.</span></th>
                <td>
                <fieldset>
                <ul>
                    <li>
                    <label for="notify">Activate Email Notification:</label> 
                    <input name="notify" id="notify" type="checkbox" value="1" <?php formpress_form_notify($form_ID); ?> />
                   	</li>
                    <li>
                    <label for="email">Email Address(es):</label> 
                    <input name="email" id="email" size="40" value="<?php formpress_form_email($form_ID); ?>" /> 
                    </li>
                </ul>
                </fieldset>
                </td>
                </tr>     
                <tr>
                <th scope="row">Button Label:</th>
                <td><input name="button" id="button" size="40" value="<?php formpress_form_button($form_ID); ?>" /></td>
                </tr>
                <tr>
                <th scope="row"><?php echo __("Response"); ?>:</th>
                <td><textarea name="response" id="response" cols="60" rows="20"><?php echo stripslashes(formpress_form_response($form_ID)); ?></textarea></td>
                </tr>
                </table>

                <p class="submit"><input name="update" type="submit" value="Update" /></p>

				<h3 id="example">Example HTML</h3>
				<p>You can insert this form using this code: <pre>[formpress_form:<?php echo $form_ID; ?>]</pre> on a page or post or you can</p>
            	<p>Copy and paste the contents of this textbox into the HTML (Code) view of a Post or Page to test the form.</p>
            	<textarea id="examplehtml" rows="25" cols="75"><?php echo "<?php\n"; ?>
global $wpdb;

	$tmp_form_ID = $wpdb->escape($_REQUEST['form_ID']);
	if ( !empty($tmp_form_ID) ) {
<?php echo "?>\n"; ?>
[formpress_form:<?php echo $form_ID; ?>]
<?php echo "<?php\n"; ?>
return;
	}
<?php echo "?>\n"; ?>
<?php htmlentities(formpress_the_html($form_ID)); ?></textarea>                
                <!--
                <p>Use the following URL as the <em>action</em> attribute for your HTML form page:</p>
                <p><input id="actionurl" type="text" size="99" value="<?php echo $site_url; ?>?formpress_submit=<?php echo $form_ID; ?>" /></p>
                -->
                </form>
            </div>
            <?php
			
			break;
		case 'saveform':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$result = formpress_save_order($form_ID, $_REQUEST);
			$result = formpress_save_form($form_ID, $_REQUEST);
			echo "<div class='wrap'><p>Processing ...</p></div>";
			// wp_redirect($site_url.$manage_url."&status=saveform&action=editform&id=".$form_ID);
			echo '<a href="'.$site_url.$manage_url."&status=saveform&action=editform&id=".$form_ID.'">'.__('Back to Form').'</a>'."\n";
?>
<script language="JavaScript">
<!--
function jump() {
	window.location = '<?php echo $site_url.$manage_url."&status=saveform&action=editform&id=".$form_ID; ?>'
}
var timer=setTimeout('jump()',3000)
//-->
</script>
<?php			
			break;
		case 'deleteform':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$result = formpress_delete_form($form_ID);
			// echo '<div class="wrap"><p>Processing...</p></div>';
			if ( $result ) wp_redirect($site_url.$manage_url."&status=deleteform");
			break;
		case 'deletefield':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$field_ID = $wpdb->escape($_REQUEST['field']);
			$result = formpress_delete_field($form_ID, $field_ID);
			// echo '<div class="wrap"><p>Processing...</p></div>';
			if ( $result ) wp_redirect($site_url.$manage_url."&status=deletefield&action=editform&id=$form_ID");
			break;
		case 'deleterecord':
			$session_ID = $wpdb->escape($_REQUEST['session']);
			$form_ID = $wpdb->escape($_REQUEST['form']);
			$result = formpress_delete_record($session_ID, $form_ID, $field_ID);
			echo '<div class="wrap"><p>Processing...</p></div>';
			if ( $result ) wp_redirect($site_url.$manage_url."&status=deleterecord&action=view&id=$form_ID");
			break;
		case 'deletedata':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$result = formpress_delete_data($form_ID);
			echo '<div class="wrap"><p>Processing...</p></div>';
			if ( $result ) wp_redirect($site_url.$manage_url."&status=deletedata&action=view&id=$form_ID");
			break;
		case 'showfield':
			$form_ID = $wpdb->escape($_REQUEST['id']);

			do_action( 'admin_notices' );
			
			?>
			<div class="wrap">
				<h2>Add Data Field</h2>
                <form name="showfield" id="showfield" action="<?php echo $site_url.$manage_url; ?>&action=addfield&id=<?php echo $form_ID; ?>" method="post">
		        <table class="optiontable" width="100%" cellspacing="2" cellpadding="5">
                <tr>
                <th scope="row">Field Name:</span></th>
                <td><input name="name" id="name" size="50" /></td>
                </tr>
                <tr>
                <th scope="row">Description (optional):</th>
                <td><textarea name="description" id="description" cols="47" rows="3"></textarea></td>
                </tr>
                <tr>
                <th scope="row">Type:</th>
                <td>
                	<select name="selectable">
						<option value="0"<?php echo (($field->selectable=='0')?' selected="selected"':''); ?>>Text Field</option>
						<option value="1"<?php echo (($field->selectable=='1')?' selected="selected"':''); ?>>Select Field</option>
						<option value="2"<?php echo (($field->selectable=='2')?' selected="selected"':''); ?>>Calendar Field</option>
						<option value="3"<?php echo (($field->selectable=='3')?' selected="selected"':''); ?>>Radio Field</option>
						<option value="4"<?php echo (($field->selectable=='4')?' selected="selected"':''); ?>>Comment</option>
						<option value="5"<?php echo (($field->selectable=='5')?' selected="selected"':''); ?>>Textarea Field</option>
                	</select>
                </td>
                </tr>
                <tr>
                <th scope="row">Character Limit:<span class="description">Determine the maximum number of characters<br />that can be stored in this field.</span></th>
                <td><input name="size" id="size" size="5" /></td>
                </tr>
                <tr>
                <th scope="row">Dependent:</th>
                <td>
                	<select name="dependent">
                	<option value="0"><?php echo __("Select"); ?></option>
                <?php formpress_field_list($form_ID, 'select'); ?>
                	</select>
                </td>
                </tr>
                <tr>
                <th scope="row">Required:<span class="description">Must this field be filled out to allow form submission?</span></th>
                <td><input name="required" id="required" type="checkbox" value="1" /></td>
                </tr>
                <tr>
                <th scope="row"><br />- <?php echo __("or"); ?> -</th>
                <td>&nbsp;</td>
                </tr>
                <tr>
                <th scope="row">Existing Field:</span></th>
                <td><select name="existing" id="existing">
                	<option value="0"><?php echo __("Select"); ?></option>
                <?php formpress_field_list($form_ID, 'select', 1); ?>
                </select></td>
                </tr>
                </table>
                <p class="submit"><input name="addfield" type="submit" value="Add Field &#187;" /></p>
                </form>
			</div>
            
            <?php
			break;
		case 'addfield':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$field_name = $wpdb->escape($_REQUEST['name']);
			$field_description = $wpdb->escape($_REQUEST['description']);
			$field_size = $wpdb->escape($_REQUEST['size']);
			$field_selectable = $wpdb->escape($_REQUEST['selectable']);
			$field_required = $wpdb->escape($_REQUEST['required']);
			$field_existing = $wpdb->escape($_REQUEST['existing']);
			$field_dependent = $wpdb->escape($_REQUEST['dependent']);

			if ($field_existing) {
				formpress_add_field_to_form($form_ID, $field_existing);
				echo '<div class="wrap"><p>'.__("Existing field added...").'</p></div>';		
			}
			elseif ( !empty($field_name) || !empty($field_size) ) { // || !empty($user_ID) ) {
				// store form in db and grab ID
				$field_id = formpress_add_field($form_ID, $field_name, $field_description, $field_size, $field_value, $field_selectable, $field_dependent, $field_same, $field_required);
				echo '<div class="wrap"><p>'.__("New field added...").'</p></div>';		
			} else {
				// ERROR
				echo '<div class="wrap"><p>'.__("Missing required info").'</p></div>';		
			}

			echo '<a href="'.$site_url.$manage_url.'&status=addfield&action=editform&id='.$form_ID.'">'.__('Back to Form').'</a>'."\n";
?>
<script language="JavaScript">
<!--
function jump() {
	window.location = '<?php echo $site_url.$manage_url.'&status=addfield&action=editform&id='.$form_ID; ?>'
}
var timer=setTimeout('jump()',3000)
//-->
</script>
<?php
			// wp_redirect($site_url.$manage_url."&status=addfield&action=editform&id=".$form_ID);
			break;
		case 'view':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			?>
            <div class="wrap">
            	<h2>Results (<a href="<?php echo $site_url.$manage_url; ?>&action=viewexport&id=<?php echo $form_ID; ?>">export to file</a>)</h2>
                <table class="widefat">
                <?php formpress_results_head($form_ID, '<thead>', '</thead>'); ?>
                <?php formpress_results_data($form_ID, '<tbody>', '</tbody>'); ?>
                </table>
                <form name="export" id="export" action="<?php echo $site_url.$manage_url; ?>&action=deletedata&id=<?php echo $form_ID; ?>" method="post">
                <p class="submit"><input name="export" type="submit" value="Delete All Results"  onclick="return deleteSomething( 'You are about to delete all results stored for this form. This action cannot be undone!\n\n\'OK\' to delete, \'Cancel\' to stop.' );" /></p>
                </form>
            </div>
            <?php
			break;
		case 'editfield':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$field_ID = $wpdb->escape($_REQUEST['field_id']);
			$field = formpress_field_data($field_ID);
			?>
			<div class="wrap">
				<h2>Edit Data Field</h2>
          <form name="editfield" id="editfield" action="<?php echo $site_url.$manage_url; ?>&action=savefield&id=<?php echo $form_ID; ?>&field_id=<?php echo $field_ID; ?>" method="post">
		        <table class="optiontable" width="100%" cellspacing="2" cellpadding="5">
                <tr>
                <th scope="row">Field Name:</span></th>
                <td><input name="name" id="name" size="50" value="<?php echo $field->name; ?>" /></td>
                </tr>
                <tr>
                <th scope="row">Description (optional):</th>
                <td><textarea name="description" id="description" cols="47" rows="3"><?php echo $field->description; ?></textarea></td>
                </tr>
                <tr>
                <th scope="row">Type:</th>
                <td>
                	<select name="selectable">
						<option value="0"<?php echo (($field->selectable=='0')?' selected="selected"':''); ?>>Text Field</option>
						<option value="1"<?php echo (($field->selectable=='1')?' selected="selected"':''); ?>>Select Field</option>
						<option value="2"<?php echo (($field->selectable=='2')?' selected="selected"':''); ?>>Calendar Field</option>
						<option value="3"<?php echo (($field->selectable=='3')?' selected="selected"':''); ?>>Radio Field</option>
						<option value="4"<?php echo (($field->selectable=='4')?' selected="selected"':''); ?>>Comment</option>
						<option value="5"<?php echo (($field->selectable=='5')?' selected="selected"':''); ?>>Textarea Field</option>
						<option value="6"<?php echo (($field->selectable=='6')?' selected="selected"':''); ?>>Hidden Field</option>
                	</select>
                </td>
                </tr>
                <tr>
                <th scope="row">Default Value:</span></th>
                <td><textarea name="value" id="value" cols="35" rows="2"><?php echo stripslashes($field->value); ?></textarea></td>
                </tr>
                <tr>
                <th scope="row">Character Limit:<span class="description">Determine the maximum number of characters<br />that can be stored in this field.</span></th>
                <td><input name="size" id="size" size="5" value="<?php echo $field->size; ?>" /></td>
                </tr>
                <tr>
                <th scope="row">Dependent:</th>
                <td>
                	<select name="dependent">
                	<option value="0"><?php echo __("Select"); ?></option>
                <?php formpress_field_list($form_ID, 'select', 0, $field->dependent); ?>
                	</select>
                </td>
                </tr>
                <tr>
                <th scope="row">Required:<span class="description">Must this field be filled out to allow form submission?</span></th>
                <td><input name="required" id="required" type="checkbox" value="1" <?php if ($field->required) echo 'checked="checked" '; ?>/></td>
                </tr>
                <tr>
                <th scope="row">Same values as:</th>
                <td>
                	<select name="same">
						<option value="0"<?php echo (($field->same=='0')?' selected="selected"':''); ?>>--</option>
                <?php /* formpress_field_list(0, 'select', 0, $field->same); */ ?>
<?
            $field_select = formpress_get_field_select_list();
							foreach ( $field_select as $select ) {
								$select_value = $select->ID;
								$select_data = $select->name;
								?><option value="<?php echo $select_value; ?>" <?php echo (($field->same==$select_value)? ' selected="selected"':''); ?>><?php echo $select_data; ?></option>
								<?php
							}
?>
                	</select>
                </td>
                </tr>
                </table>
                <p class="submit"><input name="editfield" type="submit" value="Edit Field &#187;" /></p>
                </form>
            <?php if ( $field->selectable == '1' || $field->selectable == '3'): ?>
				<h2>Values</h2>
          <form name="updatevalues" id="updatevalues" action="<?php echo $site_url.$manage_url; ?>&action=updatevalues&id=<?php echo $form_ID; ?>&field_id=<?php echo $field_ID; ?>&<?php echo (($_GET["p"]) ? "p=".$_GET["p"]."&" : ''); ?>" method="post">
				<table class="widefat">
					<tr>
						<th scope="col" class="centered"><?php echo __("Value"); ?></th>
						<th scope="col" class="centered"><?php echo __("Data"); ?></th>
						<th scope="col" class="centered"><?php echo __("Form"); ?></th>
						<th scope="col" class="centered"><?php echo __("Dependent"); ?></th>
						<th scope="col" class="centered">&nbsp;</th>
					</tr>
					<?php 
						$p = ($_GET["p"]) ? $_GET["p"] : '0';
						$tmp_per_page = 20;
						$field_list = formpress_get_field_select_data($field_ID, $tmp_per_page, $p);
						$table_name = $wpdb->prefix . "formpress_forms";
						$query = "SELECT * FROM `$table_name`";
						$form_list = $wpdb->get_results($query);
						$table_name = $wpdb->prefix . "formpress_select";
						$query = "SELECT * FROM `$table_name` where field = '".$field->dependent."'";
						$dependent_list = $wpdb->get_results($query);
					if ( $field_list ) {
						$i = 1;
						$row_class = ( $i++ % 2 == 1 ) ? "alternate" : "";
						foreach ( $field_list as $field ) {
					?>
					<tr class="<?php echo $row_class; ?>">
						<td><input name="value-<?php echo $field->ID; ?>" size="5" value="<?php echo $field->value; ?>" /></td>
						<td><input name="data-<?php echo $field->ID; ?>" size="15" value="<?php echo $field->data; ?>" /></td>
						<td><select name="form-<?php echo $field->ID; ?>">
							<option value="0"<?php if ($field->form == '0') echo ' selected="selected"'; ?>>---</option>
							<?php foreach ( $form_list as $form ) { ?>
							<option value="<?php echo $form->ID; ?>"<?php if ($field->form == $form->ID) echo ' selected="selected"'; ?>><?php echo $form->name; ?></option>
							<? } ?>
							</select></td>
						<td><select name="dependent-<?php echo $field->ID; ?>">
							<option value="0"<?php if ($field->dependent == '0') echo ' selected="selected"'; ?>>---</option>
							<?php foreach ( $dependent_list as $dependent ) { ?>
							<option value="<?php echo $dependent->ID; ?>"<?php if ($field->dependent == $dependent->ID) echo ' selected="selected"'; ?>><?php echo $dependent->value; ?> - <?php echo $dependent->data; ?></option>
							<? } ?>
						</select><!-- input name="dependent-<?php echo $field->ID; ?>" size="3" value="<?php echo $field->dependent; ?>" /--></td>
						<td><input type="checkbox" name="del-<?php echo $field->ID; ?>" value="1" />&nbsp;<?php echo __("Delete"); ?></td>
					</tr>
				<?php 
						$row_class = ( $i++ % 2 == 1 ) ? "alternate" : "";
						} } ?>
					<tr class="<?php echo $row_class; ?>">
						<td><input name="value-0" size="5" value="" /></td>
						<td><input name="data-0" size="15" value="" /></td>
						<td><select name="form-0">
							<option value="0">---</option>
							<?php foreach ( $form_list as $form ) { ?>
							<option value="<?php echo $form->ID; ?>"><?php echo $form->name; ?></option>
							<? } ?>
							</select></td>
						<td><select name="dependent-0">
							<option value="0">---</option>
							<?php foreach ( $dependent_list as $dependent ) { ?>
							<option value="<?php echo $dependent->ID; ?>"><?php echo $dependent->value; ?> - <?php echo $dependent->data; ?></option>
							<? } ?>
						</select><!-- input name="dependent-<?php echo $field->ID; ?>" size="3" value="<?php echo $field->dependent; ?>" /--></td>
						<td>&nbsp;</td>
					</tr>
					<tr class="<?php echo $row_class; ?>">
						<td colspan="5"><?php 
							$tmp_url = "page=".$_GET["page"]."&action=".$_GET["action"]."&id=".$_GET["id"]."&field_id=".$_GET["field_id"];
							$tmp_total = formpress_get_field_select_count($field_ID);
							formpress_page_records(
							($_GET["p"] > 0) ? $_GET["p"] : '0', $tmp_total->count, $tmp_url, $tmp_per_page); ?></td>
					</tr>
					<tr class="<?php echo $row_class; ?>">
						<td colspan="5">
                <p class="submit"><input name="update" type="submit" value="<?php echo __("Update"); ?>" /></p>
						</td>
					</tr>
				</table>
			</form>
            <?php else : ?>
            <?php endif; ?>
			</div>
            <?php
			break;
		case 'updatevalues':
			// print_r($_POST);
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$field_ID = $wpdb->escape($_REQUEST['field_id']);
			$p = ($_GET["p"]) ? $_GET["p"] : '0';
			$tmp_per_page = 20;
			$field_list = formpress_get_field_select_data($field_ID, $tmp_per_page, $p);
			if ( $field_list ) {
				foreach ( $field_list as $field ) {
					if ($_POST["value-".$field->ID] != $field->value ||
						$_POST["data-".$field->ID] != $field->data ||
						$_POST["form-".$field->ID] != $field->form ||
						$_POST["dependent-".$field->ID] != $field->dependent
						) {
							$table_name = $wpdb->prefix . "formpress_select";
							$sql = "update $table_name set
							value = '".$_POST["value-".$field->ID]."',
							data = '".$_POST["data-".$field->ID]."',
							form = '".$_POST["form-".$field->ID]."',
							dependent = '".$_POST["dependent-".$field->ID]."'
							where  ID = ".$field->ID.";";
							// echo $sql;
						$wpdb->query($sql);
					}
					if ($_POST["del-".$field->ID] == '1') {
						$table_name = $wpdb->prefix . "formpress_select";
						$sql = "delete from $table_name 
							where ID = '".$field->ID."'";
						// echo $sql;
						$wpdb->query($sql);
					}
				}
			}
			if ($_POST["value-0"] != "") {
				$table_name = $wpdb->prefix . "formpress_select";
				$sql = "insert into $table_name (ID, form, field, value, data, dependent)
				values (0, '".$_POST["form-0"]."', '".$field_ID."', '".$_POST["value-0"]."', '".$_POST["data-0"]."', '".$_POST["dependent-0"]."');";
				// echo $sql;
				$wpdb->query($sql);
			}
			$tmp_url = "&action=editfield&id=".$form_ID."&field_id=".$field_ID."&".(($p) ? "p=".$p."&" : '');
			echo '<div class="wrap"><p>'.__("Values modified...").'</p></div>';
			echo '<a href="'.$site_url.$manage_url.$tmp_url.'">'.__('Back to Field').'</a>'."\n";
?>
<script language="JavaScript">
<!--
function jump() {
	window.location = '<?php echo $site_url.$manage_url.$tmp_url; ?>'
}
var timer=setTimeout('jump()',3000)
//-->
</script>
<?php
			break;
		case 'savefield':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$field_ID = $wpdb->escape($_REQUEST['field_id']);
			$field_name = $wpdb->escape($_REQUEST['name']);
			$field_description = $wpdb->escape($_REQUEST['description']);
			$field_size = $wpdb->escape($_REQUEST['size']);
			$field_same = $wpdb->escape($_REQUEST['same']);
			$field_selectable = $wpdb->escape($_REQUEST['selectable']);
			$field_required = $wpdb->escape($_REQUEST['required']);
			$field_dependent = $wpdb->escape($_REQUEST['dependent']);
			$field_value = $wpdb->escape($_REQUEST['value']);

			formpress_edit_field($field_ID, $field_name, $field_description, $field_size, $field_value, $field_selectable, $field_same, $field_dependent, $field_required);
			echo '<div class="wrap"><p>'.__("Field modified...").'</p></div>';		

			echo '<a href="'.$site_url.$manage_url.'&status=savefield&action=editform&id='.$form_ID.'">'.__('Back to Form').'</a>'."\n";
			// wp_redirect($site_url.$manage_url."&status=addfield&action=editform&id=".$form_ID);
?>
<script language="JavaScript">
<!--
function jump() {
	window.location = '<?php echo $site_url.$manage_url."&status=savefield&action=editform&id=".$form_ID; ?>'
}
var timer=setTimeout('jump()',3000)
//-->
</script>
<?php
			break;
		case 'viewexport':
			$form_ID = $wpdb->escape($_REQUEST['id']);
			$form_name = formpress_get_form_option($form_ID, 'name');
			?>
            <div class="wrap">
				<h2>Export Results</h2>
                <div class="narrow">
                <h3>Form: <?php echo $form_name; ?></h3>
                <p>When you click the button below, FormPress will create a file based on the selected file format for you to save to your computer.</p>
                <p>The file will contain all of the current results for this form.</p>
                <form name="export" id="export" action="<?php echo $site_url; ?>/?formpress_export=<?php echo $form_ID; ?>" method="post">
                <h3>File Format</h3>
				<select name="format" id="format">
                	<option value="tab">Tab-delimited text</option>
                </select>
                <p class="submit"><input name="export" type="submit" value="Download Export File &#187;" /></p>
                </form>
                </div>
            </div>
            <?php
			break;
		default:
	?>
	<div class="wrap">
		<h2>Forms (<a href="#addnew">add new</a>)</h2>
		<p>A web form has three parts that work together: the HTML page that displays the form, the script that processes a submission of form data, and a database where the data can be stored. This tool helps you to setup the database for a form, processes any form submissions, and also provides example HTML code useful in building the form's web page. <a href="#addnew">Add a new form below &#187;</a></p>
        <table class="widefat">
        <thead>
        <tr>
        <th scope="col" id="hdr_ID" class="centered">ID</th>
        <th scope="col" id="hdr_name">Name</th>
        <th scope="col" id="hdr_description">Description</th>
        <th scope="col" id="hdr_owner">Owner</th>
        <th scope="col" id="hdr_action" colspan="3" class="centered">Action</th>
        </tr>
        </thead>
        <tbody id="the-list"> 

        <?php formpress_form_list('table'); ?>
        
        </tbody>
        </table>
	</div>
	
	<div class="wrap">
		<h2 id="addnew">Add Form</h2>
        <form name="addform" id="addform" action="<?php echo $site_url . $manage_url; ?>&action=addform" method="post">
        <table class="optiontable" width="100%" cellspacing="2" cellpadding="5">
		<tr>
        <th scope="row">Form Name:</th>
        <td><input name="name" id="name" size="50" /></td>
        </tr>
        <tr>
        <th scope="row">Description (optional):</th>
        <td><textarea name="description" id="description" cols="47" rows="3"></textarea></td>
        </tr>        
        </table>
        <p class="submit"><input name="createform" type="submit" value="Add Form &#187;" /></p>
        </form>
	</div>
    <?php
	}
}

formpress_show_manage_page();

?>